﻿using System;

using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using MettlerToledo.IND780.SharedDataClient;
using MettlerToledo.IND780.Softkeys;

namespace Classify_Application
{
	public partial class Form2 : Form
	{
		private SDclient SD_client = ClassifyMain.SD_client;

		private Softkeys mySoftkeys;

		private TextBox[] tbxArray = new TextBox[13];

		private int textBoxError = 0;		// offset of textbox in error

		// shared data to store textBox_class1 to textoBox_class12 color selection
		private string[] sdArray = {"ay0101", "ay0102", "ay0103",
								    "ay0104", "ay0105", "ay0106",
								    "ay0107", "ay0108", "ay0109",
								    "ay0110", "ay0111", "ay0112", "ay0113"};

		/*---------------------------------------------------------------------------------------------------------*
		* Name          :Form2::Form2
		* Description   :Constructor
		* Return Value  :None
		* --------------------------------------------------------------------------------------------------------*/
		public Form2()
		{
			InitializeComponent();

			if (SD_client.GetSharedDataConnectionStatus)		// display lime green if connected to SD server
				this.label_connected.BackColor = Color.Lime;

			this.SoftkeysInitialization();

			this.RegisterSoftkeys();

			this.Load_ClassTextBoxSelections();

		}

		/*---------------------------------------------------------------------------------------------------------*
		* Name          :Form2::Load_ClassTextBoxSelections
		* Description   :This method reads each shared data assigned to the comboBox_class comboBoxes and
		*				:sets their selected index values.
		* Return Value  :None
		* --------------------------------------------------------------------------------------------------------*/
		private void Load_ClassTextBoxSelections()
		{
			TextBox[] tbxArray = {this.textBox_class1, this.textBox_class2, this.textBox_class3,
				                  this.textBox_class4, this.textBox_class5, this.textBox_class6,
				                  this.textBox_class7, this.textBox_class8, this.textBox_class9,
				                  this.textBox_class10, this.textBox_class11, this.textBox_class12,
								  this.textBox_end_value};

			for (int i = 0; i < tbxArray.Length; i++)
			{
				string sdValueString = string.Empty;

				this.tbxArray[i] = tbxArray[i];

				// load the shared data values
				sdValueString = SD_client.ReadSharedData(this.sdArray[i]);
				this.tbxArray[i].Text = sdValueString;
			}
		}

		/*---------------------------------------------------------------------------------------------------------*
		* Name          :Form2::vScrollBar1_ValueChanged
		* Description   :The vertical scrollbar value changed event handler.  Changes the top value of panel2
		*				:to simulate vertical scrolling.
		* Return Value  :None
		* --------------------------------------------------------------------------------------------------------*/
		void vScrollBar1_ValueChanged(object sender, System.EventArgs e)
		{
			this.panel2.Top = 0 - this.vScrollBar1.Value;
			this.panel2.Refresh();
		}

		/*---------------------------------------------------------------------------------------------------------*
		* Name          :Form2::SoftkeysInitialization
		* Description   :Creates the five picture boxes and draws the softkey borders used by the softkeys
		* Return Value  :None
		* --------------------------------------------------------------------------------------------------------*/
		private void SoftkeysInitialization()
		{
			mySoftkeys = new Softkeys();
			mySoftkeys.AllocateSoftkeys(this, 175, @"Storage Card\Terminal\SKBMP\COLOR\");
		}

		/*---------------------------------------------------------------------------------------------------------*
		* Name          :Form1::RegisterSoftkeys
		* Description   :Registers the softkey graphic and method used by each softkey.
		* Return Value  :None
		* --------------------------------------------------------------------------------------------------------*/
		private void RegisterSoftkeys()
		{
			// level 0 softkeys
			mySoftkeys.LoadSoftkeys(0, 0, true, @"Storage Card\Terminal\SKBMP\COLOR\exit.bmp", (Softkeys.mySKMethodDelegate)ClassifyThresholdsExit);
			mySoftkeys.LoadSoftkeys(0, 4, true, @"Storage Card\Terminal\SKBMP\COLOR\ok.bmp", (Softkeys.mySKMethodDelegate)ClassifyThresholdsOK);

			mySoftkeys.NumberOfLevels = 1;

			mySoftkeys.DisplaySoftKeys(0);
		}

		/*---------------------------------------------------------------------------------------------------------*
		* Name          :Form2::ClassifyThresholdsExit
		* Description   :Disconnect from the shared data server and closes the form.
		* Return Value  :None
		* --------------------------------------------------------------------------------------------------------*/
		private void ClassifyThresholdsExit()
		{
			this.Close();
		}

		/*---------------------------------------------------------------------------------------------------------*
		* Name          :Form2::ClassifyThesholdsOK
		* Description   :Saves the thresholds selected for each class and then exits.
		* Return Value  :None
		* --------------------------------------------------------------------------------------------------------*/
		private void ClassifyThresholdsOK()
		{
			if (ValidateThresholds())
			{
				for (int i = 0; i < this.tbxArray.Length; i++)
				{
					string threshold = this.tbxArray[i].Text;

					SD_client.SetSharedData(this.sdArray[i], threshold.ToString());

				}
				this.ClassifyThresholdsExit();
			}

		}

		/*---------------------------------------------------------------------------------------------------------*
		* Name          :Form2::ValidateThresholds
		* Description   :Tests thresholds to be valid numbers and valid values.  A higher class must be > or =
		*				:to its preceeding class threshold value.
		* Return Value  :None
		* --------------------------------------------------------------------------------------------------------*/
		private bool ValidateThresholds()
		{
			double highestThreshold = 0.0;

			for (int i = 0; i < this.tbxArray.Length; i++)
			{
				double temp = 0.0;

				if (this.tbxArray[i].Text == string.Empty)
					continue;

				try
				{
					temp = double.Parse(this.tbxArray[i].Text);
				}
				catch
				{
					this.textBoxError = i;
					this.label_error_header.Text = "Invalid Entry " + "Class " + (i + 1).ToString();
					this.label_error_body.Text = "Entered value is not a number, please re-enter";
					this.panel_error.Visible = true;
					return false;
				}
			}

			for (int i = 0; i < this.tbxArray.Length; i++)
			{
				double tbxVal = double.Parse(this.tbxArray[i].Text);

				if (tbxVal >= highestThreshold)
				{
					highestThreshold = tbxVal;
				}
				else
				{
					if (tbxVal < 0.000001)
						continue;

					this.textBoxError = i;
					this.label_error_header.Text = "Invalid Value " + "Class " + (i + 1).ToString();
					this.label_error_body.Text = "Entered threshold is not valid for the Class, please re-enter";
					this.panel_error.Visible = true;
					return false;

				}
			}


			return true;
		}

		/*---------------------------------------------------------------------------------------------------------*
		* Name          :Form2::Form2_Paint
		* Description   :The Form2 Paint event handler.
		* Return Value  :None
		* --------------------------------------------------------------------------------------------------------*/
		void Form2_Paint(object sender, System.Windows.Forms.PaintEventArgs e)
		{
			mySoftkeys.DrawSoftkeyBorders(this);
		}

		/*---------------------------------------------------------------------------------------------------------*
		* Name          :Form2::Common_KeyUp
		* Description   :Common key-up event handler for all keys.
		* Return Value  :None
		* --------------------------------------------------------------------------------------------------------*/
		void Common_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			// the enter key will move the focus and scroll bar if necessary
			if (e.KeyCode == Keys.Enter /*&& sender is TextBox*/)
			{
				if (this.panel_error.Visible)
				{
					this.panel_error.Visible = false;
					this.tbxArray[this.textBoxError].Focus();
					this.tbxArray[this.textBoxError].SelectAll();
					this.vScrollBar1.Value = (this.textBoxError / 6) * this.vScrollBar1.Maximum; // cb 1 to 6, then 7 to 12 displayed
					return;
				}
				for (int i = 0; i < this.tbxArray.Length; i++)
				{
					if (this.tbxArray[i].Focused)
					{
						i++;
						if (i == this.tbxArray.Length)
							i = 0;
						this.vScrollBar1.Value = (i / 6) * this.vScrollBar1.Maximum; // cb 1 to 6, then 7 to 12 displayed
						this.tbxArray[i].Focus();
						this.tbxArray[i].SelectAll();
						break;
					}
				}
			}
			else if (e.KeyCode == Keys.Up)
			{
				int value = this.vScrollBar1.Value - this.vScrollBar1.SmallChange;
				if (value <= 0)
					this.vScrollBar1.Value = 0;
				else
					this.vScrollBar1.Value = value;
			}
			else if (e.KeyCode == Keys.Down)
			{
				int value = this.vScrollBar1.Value + this.vScrollBar1.SmallChange;
				if (value >= this.vScrollBar1.Maximum)
					this.vScrollBar1.Value = this.vScrollBar1.Maximum;
				else
					this.vScrollBar1.Value = value;
				e.Handled = true;
			}
			else
			{
				if (!mySoftkeys.SoftkeyDispatcher((int)e.KeyCode))
				{
				}
			}
		}

		/*---------------------------------------------------------------------------------------------------------*
		* Name          :Form2::Common_KeyDown
		* Description   :Common key-down event handler for all keys.  Forces a key click noise.
		* Return Value  :None
		* --------------------------------------------------------------------------------------------------------*/
		void Common_KeyDown(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			ClassifyMain.SD_client.SetSharedData("xc0134", "1");	// key click
		}

	}
}